/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.externalge;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import jpcsp.graphics.RE.externalge.ExternalGE;
import jpcsp.graphics.RE.externalge.NativeUtils;
import org.apache.log4j.Logger;

public class RendererThread
extends Thread {
    private static final Logger log = ExternalGE.log;
    private int lineMask;
    private Semaphore sync;
    private volatile boolean exit;
    private Semaphore response;

    public RendererThread(int lineMask) {
        this.lineMask = lineMask;
        this.sync = new Semaphore(0);
    }

    @Override
    public void run() {
        while (!this.exit) {
            if (!this.waitForSync(100)) continue;
            if (this.lineMask != 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Starting async rendering lineMask=0x%08X", this.lineMask));
                }
                NativeUtils.rendererRender(this.lineMask);
            }
            if (this.response == null) continue;
            Semaphore responseToBeReleased = this.response;
            this.response = null;
            responseToBeReleased.release();
        }
    }

    public void exit() {
        this.exit = true;
        this.sync(null);
    }

    public void sync(Semaphore response) {
        this.response = response;
        if (this.sync != null) {
            this.sync.release();
        }
    }

    private boolean waitForSync(int millis) {
        while (true) {
            try {
                if (!this.sync.tryAcquire(millis, TimeUnit.MILLISECONDS)) {
                    return false;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        return true;
    }
}

